function [stk,range,filename,pathname,filterindex,info_out] = stack_gui(varargin)
% Function that takes a stack of grayscale images and create a 3D matrix of
% the stack, because a current bug in uigetfiles which cannot handle more 
% than 100 files.  This function contains a work around.  However this bug
% is reported to be fixed by R2006b release of Matlab.
% command to create a more intuitive stack opening function
% Syntax: stk = stack_gui('path','','name','',type,'','series',[])
% Input:    Input is carried out via the uigetfile interface
%
% Output:   stk = matrix of images
%           range = the min and max scalar from each image
%           filename = the file names of the files that make up the stack
%           pathname = the path name of the files
%           filterindex = the filter index of the files.
%           info = all the meta information regarding the images

%initial error check
if nargin>1 && nargin~=6
    error(['Error: stack_gui must have three inputs (filename,pathname and filterindex) if inputs are used at all.']);
end

[filename,pathname,filterindex] = parse(varargin);

if isa(filename,'cell')   %filename{1,1}~=0  %if 0 user hit cancel. abort
    %get file info
    if filterindex~=5 %not the .m file loader
        %     try
        %         file = [pathname,filename{1,1}];
        %         info = imfinfo(file);
        %         process = 0;
        %     catch
        %         file = [pathname,filename];
        %         info = imfinfo(file);
        %         process = 1;
        %     end
        %NOTE: just a note, but iscell could be used to check if multifiles are
        %selected or a single file is selected, but the above method is useful as
        %well.  This is commented out because not it appears the filename is
        %always a cell array

        %info = imfinfo([pathname,filename{1,1}]);

        %one frame or multiple
        if size(filename,2)>1||filterindex==100
            process = 0;        %multifiles & not cell output
        else
            process = 1;        %one file
        end

        %Initiation and setup
        info = imfinfo([pathname,filename{1,1}]);
        size_x = info(1).Width;
        size_y = info(1).Height;
        slices = size(info,1);      %this is for files with mulitple layers, like an imageJ stack.
        seq = size(filename,2);
        info_out{1,1} = info;

        %Initiate the stack matrixes
        %stk = zeros(size_x,size_y,seq,'uint8');        %Initiated uint8 matrix, for imshow compatability
    end

    %Process the images into our stack format
    switch filterindex
        case 5  %an stack stored in an mat file
            load([pathname,filename{1,1}],'stk');
            %Note: this only returns a value if in the mat file there is stored
            %a matrix stk.
        otherwise   %an image series
            switch process
                case 1    %a single image...why are you using stack???...unless it is already an image stack...
                    %initiate stack matrix
                    stk = zeros(size_x,size_y,slices,['uint',num2str(info(1).BitDepth)]);
                    %stack info process started
                    if slices>1     %more than 1 slice per image
                        h = waitbar(0,'Slices Read: 0');    %initialize progress bar.
                        for i = 1:slices
                            image = imread([pathname,filename{1,1}],i);     %read each layer as a frame
                            image = image';
                            stk(:,:,i) = image;
                            range(i,1) = min(min(image));                 %Get the min value in the image
                            range(i,2) = max(max(image));                 %Get the max value in the image    
                            waitbar(i/slices,h,['Slices Read: ',num2str(i)]);   %show progress
                        end
                        close(h);   %close progress bar
                    else        %1 image...???...this function is called stack...
                        image = imread([pathname,filename{1,1}]);
                        image = image';
                        stk = image;  %Write into stack matrix
                        range(1,1) = min(min(image));                 %Get the min value in the image
                        range(1,2) = max(max(image));                 %Get the max value in the image
                    end
                otherwise      %Multiple files selected
                    %Did the user select cell array output?
                    if filterindex==100     %OK they did
                         h = waitbar(0,'Opening Image: 1');    %initialize progress bar.
                         for i = 1:seq      %Run through the files
                             info = imfinfo([pathname,filename{1,i}]);
                             size_x = info(1).Width;
                             size_y = info(1).Height;
                             slices = size(info,1);     %number of slices for this file
                             stk_temp = zeros(size_x,size_y,slices,['uint',num2str(info(1).BitDepth)]);     %initialize with image bitdepth
                             image = zeros(size_x,size_y,['uint',num2str(info(1).BitDepth)]);
                             %get the location of the second wait bar, position [left botton width height]
                             pos = get(h,'position');
                             h2 = waitbar(0,'Slices Read: 0','position',[pos(1) pos(2)+pos(4)+10 275 50]);    %initialize progress bar.
                             for j = 1:slices
                                 image = imread([pathname,filename{1,i}],j);     %read each layer as a frame
                                 image = image';
                                 stk_temp(:,:,j) = image;
                                 range(j,1) = min(min(image));                 %Get the min value in the image
                                 range(j,2) = max(max(image));                 %Get the max value in the image
                                 waitbar(j/slices,h2,['Slices Read: ',num2str(j)],'position',[pos(1) pos(2)+pos(4)+10 275 50]);   %show progress
                             end
                             close(h2);   %close progress bar
                             stk(1,i) = {stk_temp};   %form cell array
                             waitbar(i/seq,h,['Opening Image: ',num2str(i)]);
                             info_out{1,i} = info;  %output info
                         end
                         close(h)
                    else
                        %create the stack from image series
                        %comment the section after this out if it take too long
                        %to execute, but this section is designed to bring
                        %flexibility to creating a stack.  Essentially, we look
                        %at every file to see if interleaved in single files
                        %there are image stakes and incorporate them into the
                        %stack.  Imported image stacks are incorporated
                        %sequentially, so that if two image stacks are
                        %incorporated it is essentially a concatenation of the
                        %two stacks in the z axis. Note: All images must be
                        %same size
                        h = waitbar(0,'Parse Image Series: 0');    %initialize progress bar.
                        bitdepth = [];   %initialize
                        for i = 1:seq    %get image layers per image and store it in a horizontal vector.
                            info = imfinfo([pathname,filename{1,i}]);
                            slices(1,i) = size(info,1);
                            bitdepth_curr = info(1).BitDepth;   %Check for bit depth homogeneity
                            if ~isempty(bitdepth)
                                if bitdepth~=bitdepth_curr
                                    warning('You are trying to combine multiple files of different bit depth');
                                end
                            else
                                bitdepth = bitdepth_curr;
                            end
                            info_out{1,i} = info;  %output info
                            waitbar(i/seq,h,['Parse Image Series: ',num2str(i)]);   %show progress
                        end
                        close(h);           %close progress bar
                        if max(slices)>1    %there are image stacks in our midst
                            img_count = 1;
                            h = waitbar(0,'Stack Construction: 0%');    %initialize progress bar.
                            for i = 1:seq
                                if slices(1,i)>1    %a stack
                                    h2 = waitbar(0,'Image Stack Encountered-Parsing: 0%');
                                    for j = 1:slices(1,i)
                                        image = imread([pathname,filename{1,i}],j);     %Read in the image file
                                        image = image';                                 %Transpose the image array, because pixel dimensions are flipped
                                        stk(:,:,img_count) = image;                     %Write into stack matrix
                                        range(img_count,1) = min(min(image));           %Get the min value in the image
                                        range(img_count,2) = max(max(image));           %Get the max value in the image
                                        img_count = img_count+1;
                                        waitbar(i/slices(1,i),h2,['Image Stack Encountered-Parsing: ',round(i/slices(1,i))*100,'%']);   %show progress
                                    end
                                    close(h2);      %close progress bar
                                else    %a single image
                                    image = imread([pathname,filename{1,i}]);     %Read in the image file
                                    image = image';                                 %Transpose the image array, because pixel dimensions are flipped
                                    stk(:,:,img_count) = image;                     %Write into stack matrix
                                    range(img_count,1) = min(min(image));           %Get the min value in the image
                                    range(img_count,2) = max(max(image));           %Get the max value in the image
                                    img_count = img_count+1;
                                end
                                waitbar(i/seq,h,['Stack Construction: ',round(i/seq)*100,'%']);   %show progress
                            end
                            close(h);       %close progress bar
                        else    %all single images.
                            h = waitbar(0,'Image Read: 0');    %initialize progress bar.
                            for i = 1:seq                                  %Cycle through the files
                                image = imread([pathname,filename{1,i}]);     %Read in the image file
                                image = image';                               %Transpose the image array, because pixel dimensions are flipped
                                stk(:,:,i) = image;                           %Write into stack matrix
                                range(i,1) = min(min(image));                 %Get the min value in the image
                                range(i,2) = max(max(image));                 %Get the max value in the image
                                waitbar(i/seq,h,['Image Read: ',num2str(i)]);   %show progress
                            end
                            close(h);
                        end
                    end
            end
    end
else    %user canceled
    stk = 0;
    range = 0;
    seq = 0;
end
%report function processes to user
disp([num2str(seq),' files were processed sucessfully.']);
if iscell(stk)      %cell output activated
    disp(['There are ',num2str(size(stk,2)),' stacks, and ' num2str(size(stk{1,1},3)),' images in each stack.']);  %note not actually accurate.
else
    disp(['There are ',num2str(size(stk,3)),' in the stack.']);
end
%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [filename,pathname,filterindex] = parse(input)

%Parse the input
if ~isempty(input)&&size(input,2)~=1  %the user entered commands! 1 input is a special case.
    for i = 1:2:size(input,2);
        if ischar(input{1,i})
            switch input{1,i}
                case 'filename'
                    filename = input{1,i+1};
                case 'pathname'
                    pathname = input{1,i+1};
                case 'filterindex'
                    filterindex = input{1,i+1};
            end
        end
    end
else    %gui time
    %this line helps get around the 100 file limitation
    setappdata(0,'UseNativeSystemDialogs',false)
    %get files. Note: currently the filterindex is not used for its actual
    %value, which is the filter selected for the file selection.
    [filename,pathname,filterindex] = uigetfile2({'*.tif','TIFF files (*.tif)';...
        '*.jpg','Jpeg files (*.jpg)';'*.gif','GIF files (*.gif)';...
        '*.bmp','Bitmap files (*.bmp)';'*.mat','Mat files (*.mat)';},'Open Stack','Multiselect','on');
    setappdata(0,'UseNativeSystemDialogs',true)
    if size(input,2)==1             %activate stack export as cell instead of concatenation, if...
        if input{1,1}~=1                 %Wrong command, only number 1 works here
            error(['Error: stack_gui must have three inputs (filename,pathname and filterindex), or the # 1 to activate cell output']);
        end
        %ok activate cell output
        filterindex = 100;
    end
end
%make sure filename is a cell array
if ischar(filename)
    filename = {filename};
end